//Falcon-180B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: futuristic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <pthread.h>

#define MAX_PROCESSES 100
#define MAX_PROCESS_NAME 20

typedef struct {
    int id;
    int burst_time;
    int waiting_time;
    int turnaround_time;
    char name[MAX_PROCESS_NAME];
} Process;

int g_num_processes = 0;
int g_current_time = 0;
int g_quantum = 2;
Process g_process_list[MAX_PROCESSES];

void add_process(int id, int burst_time, char* name) {
    if (g_num_processes >= MAX_PROCESSES) {
        printf("Error: Too many processes!\n");
        return;
    }

    g_process_list[g_num_processes].id = id;
    g_process_list[g_num_processes].burst_time = burst_time;
    strncpy(g_process_list[g_num_processes].name, name, MAX_PROCESS_NAME);
    g_num_processes++;
}

void execute_processes() {
    int i;
    for (i = 0; i < g_num_processes; i++) {
        if (g_process_list[i].burst_time > 0) {
            g_current_time += g_quantum;
            if (g_current_time >= g_process_list[i].burst_time) {
                g_current_time = g_process_list[i].burst_time;
                g_process_list[i].burst_time = 0;
            } else {
                g_process_list[i].burst_time -= g_quantum;
            }
        } else {
            g_process_list[i].waiting_time += g_quantum;
            g_current_time += g_quantum;
        }
    }

    int completed_processes = 0;
    for (i = 0; i < g_num_processes; i++) {
        if (g_process_list[i].burst_time == 0 && g_process_list[i].waiting_time == 0) {
            completed_processes++;
            g_process_list[i].turnaround_time = g_current_time - g_process_list[i].waiting_time - g_process_list[i].burst_time;
        }
    }

    if (completed_processes > 0) {
        printf("Completed processes: %d\n", completed_processes);
    }
}

int main() {
    srand(time(NULL));

    add_process(1, 5, "Process 1");
    add_process(2, 3, "Process 2");
    add_process(3, 8, "Process 3");

    execute_processes();

    return 0;
}