//Gemma-7B DATASET v1.0 Category: Traffic Flow Simulation ; Style: cheerful
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_CARS 10

typedef struct Car {
    int position;
    int direction;
    int speed;
} Car;

void simulateTrafficFlow(Car cars[], int numCars) {
    for (int i = 0; i < numCars; i++) {
        switch (cars[i].direction) {
            case 1:
                cars[i].position++;
                if (cars[i].position >= MAX_CARS - 1) {
                    cars[i].direction = -1;
                }
                break;
            case -1:
                cars[i].position--;
                if (cars[i].position <= 0) {
                    cars[i].direction = 1;
                }
                break;
        }

        cars[i].speed++;
        if (cars[i].speed >= 5) {
            cars[i].speed = 0;
        }
    }
}

int main() {
    Car cars[MAX_CARS];
    int numCars = 5;

    for (int i = 0; i < numCars; i++) {
        cars[i].position = i;
        cars[i].direction = 1;
        cars[i].speed = 0;
    }

    simulateTrafficFlow(cars, numCars);

    for (int i = 0; i < numCars; i++) {
        printf("Car %d is at position %d, direction %d, speed %d\n", i, cars[i].position, cars[i].direction, cars[i].speed);
    }

    return 0;
}