//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: configurable
#include <stdio.h>
#include <stdlib.h>

#define MAX_PROCESS 5

typedef struct Process {
    int id;
    int burstTime;
    int waitingTime;
    int turnaroundTime;
} Process;

void calculateWaitingTime(Process *processes) {
    int i = 0;
    for (i = 0; i < MAX_PROCESS; i++) {
        processes[i].waitingTime = processes[i].burstTime - 1;
    }
}

void calculateTurnaroundTime(Process *processes) {
    int i = 0;
    for (i = 0; i < MAX_PROCESS; i++) {
        processes[i].turnaroundTime = processes[i].burstTime + processes[i].waitingTime;
    }
}

int main() {
    Process processes[MAX_PROCESS];

    // Assign burst time for each process
    processes[0].burstTime = 5;
    processes[1].burstTime = 3;
    processes[2].burstTime = 8;
    processes[3].burstTime = 4;
    processes[4].burstTime = 6;

    // Calculate waiting time for each process
    calculateWaitingTime(processes);

    // Calculate turnaround time for each process
    calculateTurnaroundTime(processes);

    // Print waiting time and turnaround time for each process
    int i = 0;
    for (i = 0; i < MAX_PROCESS; i++) {
        printf("Process ID: %d, Waiting Time: %d, Turnaround Time: %d\n", processes[i].id, processes[i].waitingTime, processes[i].turnaroundTime);
    }

    return 0;
}