//Falcon-180B DATASET v1.0 Category: Network Topology Mapper ; Style: irregular
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NODES 1000
#define MAX_LINKS 10000

typedef struct {
    int id;
    char name[20];
    int degree;
    int *links;
} Node;

typedef struct {
    int src;
    int dest;
    int weight;
} Link;

Node nodes[MAX_NODES];
Link links[MAX_LINKS];

int num_nodes = 0;
int num_links = 0;

void add_node(int id, char *name) {
    Node *node = &nodes[num_nodes++];
    node->id = id;
    strcpy(node->name, name);
    node->degree = 0;
    node->links = NULL;
}

void add_link(int src, int dest, int weight) {
    Link *link = &links[num_links++];
    link->src = src;
    link->dest = dest;
    link->weight = weight;
    nodes[src-1].degree++;
    nodes[dest-1].degree++;
}

void print_node(Node *node) {
    printf("ID: %d, Name: %s, Degree: %d\n", node->id, node->name, node->degree);
}

void print_link(Link *link) {
    printf("Source: %d, Destination: %d, Weight: %d\n", link->src, link->dest, link->weight);
}

int main() {
    add_node(1, "Node 1");
    add_node(2, "Node 2");
    add_node(3, "Node 3");
    add_node(4, "Node 4");
    add_link(1, 2, 5);
    add_link(2, 3, 3);
    add_link(3, 4, 2);
    add_link(4, 1, 4);
    print_node(nodes);
    print_link(links);
    return 0;
}