//Falcon-180B DATASET v1.0 Category: Drone Remote Control ; Style: asynchronous
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <termios.h>
#include <errno.h>
#include <string.h>

#define BAUD_RATE B9600

// Function prototypes
void setup_serial_port(int fd, speed_t baud_rate);
int main(int argc, char *argv[]) {
    int fd;
    struct termios options;
    char *port_name = "/dev/ttyUSB0";

    fd = open(port_name, O_RDWR | O_NOCTTY);

    if (fd == -1) {
        printf("Error opening serial port. ");
        exit(1);
    }

    if (tcgetattr(fd, &options)!= 0) {
        printf("Error getting serial port attributes. ");
        exit(2);
    }

    options.c_cflag = BAUD_RATE | CS8 | CLOCAL | CREAD;
    options.c_iflag = IGNPAR;
    options.c_oflag = 0;
    options.c_lflag = 0;
    options.c_cc[VMIN] = 1;
    options.c_cc[VTIME] = 0;

    if (tcsetattr(fd, TCSANOW, &options)!= 0) {
        printf("Error setting serial port attributes. ");
        exit(3);
    }

    setup_serial_port(fd, BAUD_RATE);

    close(fd);
    return 0;
}

void setup_serial_port(int fd, speed_t baud_rate) {
    struct termios options;

    if (tcgetattr(fd, &options)!= 0) {
        printf("Error getting serial port attributes. ");
        exit(1);
    }

    options.c_cflag &= ~CSTOPB;
    options.c_cflag &= ~CSIZE;
    options.c_cflag |= CS8;

    options.c_cflag &= ~PARENB;
    options.c_cflag &= ~PARODD;

    options.c_iflag &= ~(IXON | IXOFF | IXANY);
    options.c_iflag |= IGNPAR;

    options.c_oflag &= ~OPOST;

    options.c_lflag &= ~(ICANON | ECHO | ECHOE | ISIG);

    options.c_cc[VTIME] = 10;
    options.c_cc[VMIN] = 1;

    cfsetispeed(&options, baud_rate);
    cfsetospeed(&options, baud_rate);

    if (tcsetattr(fd, TCSANOW, &options)!= 0) {
        printf("Error setting serial port attributes. ");
        exit(1);
    }
}