//Falcon-180B DATASET v1.0 Category: File system simulation ; Style: Cyberpunk
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_FILES 1000
#define MAX_FILE_NAME_LENGTH 64

typedef struct {
    char file_name[MAX_FILE_NAME_LENGTH];
    int file_size;
    int file_type;
} File;

void create_file(File *file_system, int num_files, char *file_name, int file_size, int file_type) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(file_system[i].file_name, file_name) == 0) {
            printf("File already exists.\n");
            return;
        }
    }
    strcpy(file_system[num_files].file_name, file_name);
    file_system[num_files].file_size = file_size;
    file_system[num_files].file_type = file_type;
    printf("File created successfully.\n");
}

void delete_file(File *file_system, int num_files, char *file_name) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(file_system[i].file_name, file_name) == 0) {
            memset(&file_system[i], 0, sizeof(File));
            printf("File deleted successfully.\n");
            return;
        }
    }
    printf("File not found.\n");
}

void list_files(File *file_system, int num_files) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (file_system[i].file_name[0]!= '\0') {
            printf("%s (%d bytes) - Type: %d\n", file_system[i].file_name, file_system[i].file_size, file_system[i].file_type);
        }
    }
}

int main() {
    File file_system[MAX_FILES];
    int num_files = 0;

    create_file(file_system, num_files, "manifest.txt", 1024, 1);
    create_file(file_system, num_files, "readme.txt", 512, 2);
    create_file(file_system, num_files, "license.txt", 2048, 3);

    list_files(file_system, num_files);

    delete_file(file_system, num_files, "readme.txt");

    list_files(file_system, num_files);

    return 0;
}