//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: shocked
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_PROCESSES 5
#define MAX_SCHEDULE_SIZE 10

typedef struct Process {
    int process_id;
    int arrival_time;
    int burst_time;
    int waiting_time;
    int turnaround_time;
} Process;

Process processes[MAX_PROCESSES];
int schedule[MAX_SCHEDULE_SIZE];
int current_time = 0;

void initialize_processes() {
    for (int i = 0; i < MAX_PROCESSES; i++) {
        processes[i].process_id = i + 1;
        processes[i].arrival_time = rand() % MAX_SCHEDULE_SIZE;
        processes[i].burst_time = rand() % MAX_SCHEDULE_SIZE;
        processes[i].waiting_time = 0;
        processes[i].turnaround_time = 0;
    }
}

void schedule_process(Process *process) {
    schedule[current_time] = process->process_id;
    current_time++;
    process->waiting_time++;
}

void calculate_turnaround_time(Process *process) {
    process->turnaround_time = current_time - process->arrival_time + process->burst_time;
}

void print_results() {
    for (int i = 0; i < MAX_PROCESSES; i++) {
        printf("Process ID: %d, Arrival Time: %d, Burst Time: %d, Waiting Time: %d, Turnaround Time: %d\n", processes[i].process_id, processes[i].arrival_time, processes[i].burst_time, processes[i].waiting_time, processes[i].turnaround_time);
    }
}

int main() {
    initialize_processes();
    for (int i = 0; i < MAX_PROCESSES; i++) {
        schedule_process(&processes[i]);
    }
    calculate_turnaround_time(processes);
    print_results();

    return 0;
}