//GPT-4o-mini DATASET v1.0 Category: System process viewer ; Style: asynchronous
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <dirent.h>
#include <string.h>
#include <sys/stat.h>
#include <pthread.h>
#include <time.h>

#define MAX_PROCESSES 1024
#define BUFFER_SIZE 256

typedef struct {
    int pid;
    char name[BUFFER_SIZE];
    int state;
} ProcessInfo;

void *fetch_process_info(void *arg);
void display_process_info(ProcessInfo *processes, int count);
int read_process_info(const char *dir, ProcessInfo *process);

int main() {
    pthread_t thread;
    ProcessInfo processes[MAX_PROCESSES];
    int count = 0;

    while (1) {
        // Create a new thread to fetch process information
        if (pthread_create(&thread, NULL, fetch_process_info, (void *)processes) != 0) {
            perror("Failed to create thread");
            exit(EXIT_FAILURE);
        }

        // Wait for the thread to finish
        pthread_join(thread, NULL);

        // Display the fetched process information
        display_process_info(processes, count);

        // Wait for a specified interval before fetching again
        sleep(2);
    }

    return 0;
}

void *fetch_process_info(void *arg) {
    ProcessInfo *processes = (ProcessInfo *)arg;
    int count = 0;

    DIR *proc_dir = opendir("/proc");
    if (!proc_dir) {
        perror("Failed to open /proc directory");
        pthread_exit(NULL);
    }

    struct dirent *entry;
    while ((entry = readdir(proc_dir)) != NULL) {
        // Only process directories that represent PIDs
        if (entry->d_type == DT_DIR) {
            int pid = atoi(entry->d_name);
            if (pid > 0) {
                ProcessInfo process;
                if (read_process_info(entry->d_name, &process) == 0) {
                    processes[count++] = process;
                }
            }
        }
    }
    closedir(proc_dir);
    return NULL;
}

int read_process_info(const char *dir, ProcessInfo *process) {
    char path[BUFFER_SIZE];
    snprintf(path, sizeof(path), "/proc/%s/stat", dir);

    FILE *file = fopen(path, "r");
    if (!file) {
        return -1;
    }

    fscanf(file, "%d %s %*s %*s %*s %*s %*s %*s %*s %*s %*s %*s %*s %*s %*s %*s %*s %*s %*s %*s", &process->pid, process->name);
    fclose(file);

    return 0;
}

void display_process_info(ProcessInfo *processes, int count) {
    printf("\033[H\033[J"); // Clear the screen
    printf("PID\tName\t\tState\n");
    printf("-------------------------------------\n");
    
    for (int i = 0; i < count; i++) {
        printf("%-8d%-16s%d\n", processes[i].pid, processes[i].name, processes[i].state);
    }

    fflush(stdout);
}