//GEMINI-pro DATASET v1.0 Category: Socket programming ; Style: real-life
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

int main() {
    // Create a socket.
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("socket");
        exit(EXIT_FAILURE);
    }

    // Bind the socket to an address.
    struct sockaddr_in addr;
    addr.sin_family = AF_INET;
    addr.sin_port = htons(5000);
    addr.sin_addr.s_addr = inet_addr("127.0.0.1");
    if (bind(sock, (struct sockaddr *) &addr, sizeof(addr)) < 0) {
        perror("bind");
        exit(EXIT_FAILURE);
    }

    // Listen for connections.
    if (listen(sock, 5) < 0) {
        perror("listen");
        exit(EXIT_FAILURE);
    }

    // Accept a connection.
    int client_sock = accept(sock, NULL, NULL);
    if (client_sock < 0) {
        perror("accept");
        exit(EXIT_FAILURE);
    }

    // Read data from the client.
    char buffer[1024];
    int n = read(client_sock, buffer, sizeof(buffer) - 1);
    if (n < 0) {
        perror("read");
        exit(EXIT_FAILURE);
    }

    // Process the data.
    buffer[n] = '\0';
    printf("Received data: %s\n", buffer);

    // Write data to the client.
    n = write(client_sock, "Hello world!", 12);
    if (n < 0) {
        perror("write");
        exit(EXIT_FAILURE);
    }

    // Close the connection.
    close(client_sock);
    close(sock);

    return 0;
}