//GEMINI-pro DATASET v1.0 Category: Poker Game ; Style: mathematical
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

// Card suits and ranks
enum suit {
  CLUBS,
  DIAMONDS,
  HEARTS,
  SPADES
};

enum rank {
  ACE,
  TWO,
  THREE,
  FOUR,
  FIVE,
  SIX,
  SEVEN,
  EIGHT,
  NINE,
  TEN,
  JACK,
  QUEEN,
  KING
};

// Card structure
typedef struct card {
  enum suit suit;
  enum rank rank;
} card;

// Deck of cards
card deck[52];

// Function to initialize the deck of cards
void initialize_deck() {
  int i, j;
  for (i = 0; i < 4; i++) {
    for (j = 0; j < 13; j++) {
      deck[i * 13 + j].suit = i;
      deck[i * 13 + j].rank = j;
    }
  }
}

// Function to shuffle the deck of cards
void shuffle_deck() {
  int i, j;
  card temp;
  for (i = 0; i < 52; i++) {
    j = rand() % 52;
    temp = deck[i];
    deck[i] = deck[j];
    deck[j] = temp;
  }
}

// Function to deal a hand of cards to a player
void deal_hand(card hand[5]) {
  int i;
  for (i = 0; i < 5; i++) {
    hand[i] = deck[i];
  }
}

// Function to compare two hands of cards
int compare_hands(card hand1[5], card hand2[5]) {
  int i;
  for (i = 0; i < 5; i++) {
    if (hand1[i].rank > hand2[i].rank) {
      return 1;
    } else if (hand1[i].rank < hand2[i].rank) {
      return -1;
    }
  }
  return 0;
}

// Function to print a hand of cards
void print_hand(card hand[5]) {
  int i;
  char suit_names[4][10] = {"Clubs", "Diamonds", "Hearts", "Spades"};
  char rank_names[13][10] = {"Ace", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Jack", "Queen", "King"};
  for (i = 0; i < 5; i++) {
    printf("%s of %s\n", rank_names[hand[i].rank], suit_names[hand[i].suit]);
  }
}

// Main function
int main() {
  // Initialize the random number generator
  srand(time(NULL));

  // Initialize the deck of cards
  initialize_deck();

  // Shuffle the deck of cards
  shuffle_deck();

  // Deal a hand of cards to each player
  card hand1[5], hand2[5];
  deal_hand(hand1);
  deal_hand(hand2);

  // Compare the two hands of cards
  int result = compare_hands(hand1, hand2);

  // Print the results
  if (result == 1) {
    printf("Player 1 wins!\n");
  } else if (result == -1) {
    printf("Player 2 wins!\n");
  } else {
    printf("Tie!\n");
  }

  // Print the hands of cards
  printf("Player 1's hand:\n");
  print_hand(hand1);
  printf("Player 2's hand:\n");
  print_hand(hand2);

  return 0;
}