//LLAMA2-13B DATASET v1.0 Category: Firewall ; Style: protected
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>

#define MAX_CLIENT_CONNECTIONS 5
#define MAX_PACKET_SIZE 1024

// Function to create a socket
int create_socket() {
    int sock;
    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("socket creation failed");
        exit(EXIT_FAILURE);
    }
    return sock;
}

// Function to accept a client connection
int accept_connection(int sock) {
    struct sockaddr_in client_addr;
    socklen_t client_len = sizeof(client_addr);
    int client_sock;

    // Accept the client connection
    client_sock = accept(sock, (struct sockaddr *)&client_addr, &client_len);
    if (client_sock < 0) {
        perror("accept failed");
        exit(EXIT_FAILURE);
    }

    // Print the client IP address and port number
    printf("Client IP: %s, Port: %d\n", inet_ntoa(client_addr.sin_addr), ntohs(client_addr.sin_port));

    return client_sock;
}

// Function to handle incoming packets
void handle_incoming_packet(int sock) {
    char buffer[MAX_PACKET_SIZE];
    socklen_t client_len = sizeof(struct sockaddr_in);
    struct sockaddr_in client_addr;

    // Receive the incoming packet
    recvfrom(sock, buffer, MAX_PACKET_SIZE, 0, (struct sockaddr *)&client_addr, &client_len);

    // Print the received packet
    printf("Received packet from client IP: %s, Port: %d\n", inet_ntoa(client_addr.sin_addr), ntohs(client_addr.sin_port));

    // Check if the packet is a SYN packet
    if (client_addr.sin_addr.s_addr == htonl(INADDR_ANY)) {
        // If it is a SYN packet, reset the client_len to 0
        client_len = 0;
    }

    // Send a SYN-ACK packet back to the client
    sendto(sock, "SYN-ACK", 8, 0, (struct sockaddr *)&client_addr, client_len);
}

// Function to handle client disconnection
void handle_disconnect(int sock) {
    printf("Client disconnected\n");

    // Close the socket
    close(sock);
}

int main() {
    int sock = create_socket();

    // Listen for incoming connections
    listen(sock, MAX_CLIENT_CONNECTIONS);

    // Accept the first incoming connection
    int client_sock = accept_connection(sock);

    // Handle incoming packets
    handle_incoming_packet(client_sock);

    // Handle client disconnection
    handle_disconnect(client_sock);

    return 0;
}