//Falcon-180B DATASET v1.0 Category: Email Client ; Style: dynamic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#define MAX_SUBJECT_LENGTH 100
#define MAX_BODY_LENGTH 1000
#define MAX_RECIPIENTS 100
#define MAX_ATTACHMENTS 10

typedef struct {
    char name[MAX_SUBJECT_LENGTH];
    char email[MAX_SUBJECT_LENGTH];
} recipient;

typedef struct {
    char filename[MAX_ATTACHMENTS][MAX_SUBJECT_LENGTH];
    char content[MAX_ATTACHMENTS][MAX_BODY_LENGTH];
} attachment;

void send_email(char* subject, char* body, int num_recipients, recipient* recipients, int num_attachments, attachment* attachments) {
    printf("Sending email with subject: %s\n", subject);
    printf("Body:\n%s\n", body);
    printf("Recipients:\n");
    for (int i = 0; i < num_recipients; i++) {
        printf("%s <%s>\n", recipients[i].name, recipients[i].email);
    }
    if (num_attachments > 0) {
        printf("\nAttachments:\n");
        for (int i = 0; i < num_attachments; i++) {
            printf("%s\n", attachments[i].filename[i]);
        }
    }
}

int main() {
    // Initialize variables
    char subject[MAX_SUBJECT_LENGTH] = "Test Email";
    char body[MAX_BODY_LENGTH] = "Hello, World!";
    int num_recipients = 2;
    recipient recipients[MAX_RECIPIENTS] = {{"John", "john@example.com"}, {"Jane", "jane@example.com"}};
    int num_attachments = 1;
    attachment attachments[MAX_ATTACHMENTS] = {{"test.txt", "This is a test attachment."}};

    // Send email
    send_email(subject, body, num_recipients, recipients, num_attachments, attachments);

    return 0;
}