//GEMINI-pro DATASET v1.0 Category: Chess AI ; Style: immersive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BOARD_SIZE 8
#define NUM_PIECES 16

typedef struct {
  int x;
  int y;
} Position;

typedef struct {
  char type;
  char color;
  Position position;
} Piece;

Piece pieces[NUM_PIECES] = {
  {'P', 'w', {0, 1}},
  {'P', 'w', {1, 1}},
  {'P', 'w', {2, 1}},
  {'P', 'w', {3, 1}},
  {'P', 'w', {4, 1}},
  {'P', 'w', {5, 1}},
  {'P', 'w', {6, 1}},
  {'P', 'w', {7, 1}},
  {'R', 'w', {0, 0}},
  {'N', 'w', {1, 0}},
  {'B', 'w', {2, 0}},
  {'Q', 'w', {3, 0}},
  {'K', 'w', {4, 0}},
  {'B', 'w', {5, 0}},
  {'N', 'w', {6, 0}},
  {'R', 'w', {7, 0}}
};

char board[BOARD_SIZE][BOARD_SIZE];

void print_board() {
  for (int i = 0; i < BOARD_SIZE; i++) {
    for (int j = 0; j < BOARD_SIZE; j++) {
      printf("%c ", board[i][j]);
    }
    printf("\n");
  }
}

int main() {
  // Initialize the board
  for (int i = 0; i < BOARD_SIZE; i++) {
    for (int j = 0; j < BOARD_SIZE; j++) {
      board[i][j] = '.';
    }
  }

  // Place the pieces on the board
  for (int i = 0; i < NUM_PIECES; i++) {
    board[pieces[i].position.x][pieces[i].position.y] = pieces[i].type;
  }

  // Print the board
  print_board();

  return 0;
}