//Falcon-180B DATASET v1.0 Category: File system simulation ; Style: imaginative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_FILE_NAME_LENGTH 50
#define MAX_FILE_SIZE 1000
#define NUM_FILES 10
#define NUM_DIRS 5

typedef struct {
    char name[MAX_FILE_NAME_LENGTH];
    char content[MAX_FILE_SIZE];
    int size;
} File;

typedef struct {
    char name[MAX_FILE_NAME_LENGTH];
    File* files[NUM_FILES];
    int num_files;
} Directory;

void create_file(File* file, char* content) {
    strcpy(file->name, "file");
    strcpy(file->content, content);
    file->size = strlen(content);
}

void create_directory(Directory* dir, char* name) {
    strcpy(dir->name, name);
    dir->num_files = 0;
}

int add_file_to_dir(Directory* dir, File* file) {
    if (dir->num_files >= NUM_FILES) {
        return -1;
    }
    dir->files[dir->num_files++] = file;
    return 0;
}

int main() {
    Directory root_dir;
    create_directory(&root_dir, "root");

    File file1;
    create_file(&file1, "Hello, world!");
    add_file_to_dir(&root_dir, &file1);

    File file2;
    create_file(&file2, "This is a test.");
    add_file_to_dir(&root_dir, &file2);

    Directory dir1;
    create_directory(&dir1, "dir1");
    File file3;
    create_file(&file3, "File in dir1.");
    add_file_to_dir(&dir1, &file3);
    add_file_to_dir(&root_dir, &dir1);

    Directory dir2;
    create_directory(&dir2, "dir2");
    File file4;
    create_file(&file4, "Another file.");
    add_file_to_dir(&dir2, &file4);
    add_file_to_dir(&root_dir, &dir2);

    printf("Root directory:\n");
    for (int i = 0; i < root_dir.num_files; i++) {
        printf("%s\n", root_dir.files[i]->name);
    }

    return 0;
}