//Falcon-180B DATASET v1.0 Category: Digital Diary ; Style: artistic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ENTRIES 50
#define MAX_ENTRY_LENGTH 500

typedef struct {
    char date[50];
    char entry[MAX_ENTRY_LENGTH];
} Entry;

Entry diary[MAX_ENTRIES];
int num_entries = 0;

void add_entry(char* date, char* entry) {
    if (num_entries >= MAX_ENTRIES) {
        printf("Diary is full!\n");
        return;
    }

    strcpy(diary[num_entries].date, date);
    strcpy(diary[num_entries].entry, entry);

    num_entries++;
}

void view_entries() {
    printf("Diary Entries:\n");
    for (int i = 0; i < num_entries; i++) {
        printf("%s - %s\n", diary[i].date, diary[i].entry);
    }
}

void search_entries(char* keyword) {
    printf("Search Results:\n");
    for (int i = 0; i < num_entries; i++) {
        if (strstr(diary[i].entry, keyword)!= NULL) {
            printf("%s - %s\n", diary[i].date, diary[i].entry);
        }
    }
}

void delete_entry(char* date) {
    for (int i = 0; i < num_entries; i++) {
        if (strcmp(diary[i].date, date) == 0) {
            memmove(&diary[i], &diary[i+1], sizeof(Entry) * (num_entries - i - 1));
            num_entries--;
            return;
        }
    }

    printf("Entry not found!\n");
}

int main() {
    add_entry("January 1, 2022", "Happy New Year!");
    add_entry("January 2, 2022", "Started my new job today.");
    view_entries();
    search_entries("job");
    delete_entry("January 2, 2022");
    view_entries();

    return 0;
}