//LLAMA2-13B DATASET v1.0 Category: Searching algorithm ; Style: active
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ARRAY_SIZE 100
#define SEARCH_ALGO_NAME "Active Search"

// Function to print the search progress
void print_progress(int curr_idx, int total_elems) {
    printf("Searching... [%d/%d]", curr_idx, total_elems);
    fflush(stdout);
}

// Function to perform the active search
int active_search(int arr[], int start, int end, int target) {
    int mid;
    int low = start;
    int high = end;

    while (low <= high) {
        mid = (low + high) / 2;

        // Check if the target is found
        if (arr[mid] == target) {
            printf("Target found at index %d\n", mid);
            return mid;
        }

        // Check if the target is less than the middle element
        if (arr[mid] < target) {
            low = mid + 1;
        } else {
            high = mid - 1;
        }

        // Print the search progress
        print_progress(mid, end - start + 1);
    }

    return -1; // Not found
}

int main() {
    int arr[MAX_ARRAY_SIZE] = {1, 2, 3, 4, 5, 6, 7, 8, 9};
    int target = 5;
    int result;

    // Perform the active search
    result = active_search(arr, 0, MAX_ARRAY_SIZE - 1, target);

    // Print the result
    if (result != -1) {
        printf("Target found at index %d\n", result);
    } else {
        printf("Target not found\n");
    }

    return 0;
}