//Falcon-180B DATASET v1.0 Category: Personal Finance Planner ; Style: secure
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define MAX_BUDGET_ITEMS 100
#define MAX_STRING_LENGTH 100
#define MAX_BUDGET_NAME_LENGTH 50
#define MAX_BUDGET_AMOUNT_LENGTH 10

typedef struct {
    char name[MAX_BUDGET_NAME_LENGTH];
    char amount[MAX_BUDGET_AMOUNT_LENGTH];
} BudgetItem;

void addBudgetItem(BudgetItem *budget, int numItems, char *name, char *amount) {
    if (numItems >= MAX_BUDGET_ITEMS) {
        printf("Error: Maximum number of budget items reached.\n");
        return;
    }
    strcpy(budget[numItems].name, name);
    strcpy(budget[numItems].amount, amount);
    numItems++;
}

void displayBudget(BudgetItem *budget, int numItems) {
    for (int i = 0; i < numItems; i++) {
        printf("%s: $%s\n", budget[i].name, budget[i].amount);
    }
}

void calculateTotalExpenses(BudgetItem *budget, int numItems) {
    double totalExpenses = 0;
    for (int i = 0; i < numItems; i++) {
        totalExpenses += atof(budget[i].amount);
    }
    printf("Total Expenses: $%.2f\n", totalExpenses);
}

int main() {
    BudgetItem budget[MAX_BUDGET_ITEMS];
    int numItems = 0;

    addBudgetItem(budget, numItems, "Rent", "1000");
    addBudgetItem(budget, numItems, "Utilities", "200");
    addBudgetItem(budget, numItems, "Groceries", "500");
    addBudgetItem(budget, numItems, "Entertainment", "300");
    addBudgetItem(budget, numItems, "Clothing", "150");
    addBudgetItem(budget, numItems, "Savings", "500");

    displayBudget(budget, numItems);
    calculateTotalExpenses(budget, numItems);

    return 0;
}