//Falcon-180B DATASET v1.0 Category: Memory management ; Style: expert-level
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <errno.h>

#define HEAP_SIZE (1024 * 1024) // 1 MB

typedef struct block_t {
    size_t size;
    int free;
    struct block_t *next;
} block_t;

static block_t *freeList = (void*)0;
static char heap[HEAP_SIZE];

void init() {
    freeList = (block_t*)heap;
    freeList->size = HEAP_SIZE - sizeof(block_t);
    freeList->free = true;
    freeList->next = (void*)0;
}

void *myMalloc(size_t numBytes) {
    block_t *current, *prev;
    void *result;

    if (freeList == NULL) {
        fprintf(stderr, "Out of memory\n");
        exit(1);
    }

    current = freeList;
    while ((((current->size) < numBytes) || ((current->free) == false)) && (current->next!= NULL)) {
        prev = current;
        current = current->next;
    }

    if (current->size == numBytes) {
        current->free = false;
        result = (void*)(++current);
        return result;
    } else if (current->size > numBytes + sizeof(block_t)) {
        block_t *newBlock = (void*)((void*)current + numBytes + sizeof(block_t));
        newBlock->size = current->size - numBytes - sizeof(block_t);
        newBlock->free = true;
        newBlock->next = current->next;
        current->size = numBytes;
        current->free = false;
        current->next = newBlock;
        result = (void*)(++current);
        return result;
    }

    return NULL;
}

void myFree(void* ptr) {
    if (ptr == NULL)
        return;

    block_t* blk = (block_t*)ptr;
    --blk;

    blk->free = true;
}

int main() {
    char* p1 = (char*)myMalloc(10);
    char* p2 = (char*)myMalloc(20);
    char* p3 = (char*)myMalloc(30);

    strcpy(p1, "Hello");
    strcpy(p2, "World");
    strcpy(p3, "!");

    printf("%s %s %s\n", p1, p2, p3);

    myFree(p1);
    myFree(p2);
    myFree(p3);

    return 0;
}