//GEMINI-pro DATASET v1.0 Category: Digital Diary ; Style: puzzling
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#define MAX_NOTES 10
#define MAX_NOTE_LENGTH 50

typedef struct note {
    char content[MAX_NOTE_LENGTH];
    time_t timestamp;
} note_t;

note_t notes[MAX_NOTES];
int num_notes = 0;

void add_note(char *content) {
    if (num_notes < MAX_NOTES) {
        strcpy(notes[num_notes].content, content);
        notes[num_notes].timestamp = time(NULL);
        num_notes++;
    } else {
        printf("Diary is full!\n");
    }
}

void delete_note(int index) {
    if (index >= 0 && index < num_notes) {
        for (int i = index; i < num_notes - 1; i++) {
            strcpy(notes[i].content, notes[i + 1].content);
            notes[i].timestamp = notes[i + 1].timestamp;
        }
        num_notes--;
    } else {
        printf("Invalid index!\n");
    }
}

void print_all_notes() {
    for (int i = 0; i < num_notes; i++) {
        printf("Note %d: %s\n", i + 1, notes[i].content);
        printf("Timestamp: %s\n", ctime(&notes[i].timestamp));
        printf("\n");
    }
}

int main() {
    add_note("This is my first note.");
    add_note("This is my second note.");
    add_note("This is my third note.");

    print_all_notes();

    delete_note(1);

    print_all_notes();

    return 0;
}