//Falcon-180B DATASET v1.0 Category: Interprocess communication ; Style: invasive
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/wait.h>

#define SHM_SIZE 4096

int shmid;
char *shmptr;

void read_from_shm(int shmid, char *shmptr) {
    printf("Reading from shared memory: %s\n", shmptr);
}

void write_to_shm(int shmid, char *shmptr) {
    sprintf(shmptr, "Hello, world!");
    printf("Wrote to shared memory.\n");
}

int main() {
    key_t key = ftok("./shm_example", 65);
    shmid = shmget(key, SHM_SIZE, IPC_CREAT | 0666);

    if (shmid == -1) {
        printf("Error creating shared memory segment.\n");
        exit(1);
    }

    shmptr = shmat(shmid, NULL, 0);

    if (shmptr == (void *) -1) {
        printf("Error attaching to shared memory segment.\n");
        exit(1);
    }

    pid_t childpid = fork();

    if (childpid == -1) {
        printf("Error forking child process.\n");
        exit(1);
    } else if (childpid == 0) {
        write_to_shm(shmid, shmptr);
        exit(0);
    } else {
        waitpid(childpid, NULL, 0);
        read_from_shm(shmid, shmptr);
    }

    return 0;
}