//Falcon-180B DATASET v1.0 Category: Sorting ; Style: medieval
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

typedef struct {
    char name[20];
    int age;
    int nobility;
} person;

// Function to compare two people based on their age
int compareAge(const void* a, const void* b) {
    person* personA = (person*)a;
    person* personB = (person*)b;
    if (personA->age < personB->age)
        return -1;
    else if (personA->age > personB->age)
        return 1;
    else
        return 0;
}

// Function to compare two people based on their nobility
int compareNobility(const void* a, const void* b) {
    person* personA = (person*)a;
    person* personB = (person*)b;
    if (personA->nobility < personB->nobility)
        return -1;
    else if (personA->nobility > personB->nobility)
        return 1;
    else
        return 0;
}

int main() {
    srand(time(NULL)); // Seed the random number generator with the current time

    // Create an array of 10 people
    person people[10];

    // Populate the array with random names, ages, and nobility levels
    for (int i = 0; i < 10; i++) {
        people[i].age = rand() % 101; // Ages range from 0 to 100
        people[i].nobility = rand() % 101; // Nobility levels range from 0 to 100
        sprintf(people[i].name, "Lord %d of House %d", i + 1, rand() % 101); // Generate a random name
    }

    // Sort the array by age
    qsort(people, 10, sizeof(person), compareAge);

    // Print the sorted array
    printf("Sorted by Age:\n");
    for (int i = 0; i < 10; i++) {
        printf("%s is %d years old.\n", people[i].name, people[i].age);
    }

    // Sort the array by nobility
    qsort(people, 10, sizeof(person), compareNobility);

    // Print the sorted array
    printf("\nSorted by Nobility:\n");
    for (int i = 0; i < 10; i++) {
        printf("%s has a nobility level of %d.\n", people[i].name, people[i].nobility);
    }

    return 0;
}