//GEMINI-pro DATASET v1.0 Category: TCP/IP Programming ; Style: mind-bending
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>

#define PORT 8080
#define BUFFER_SIZE 1024

// Mind-bending TCP/IP client program
int main(int argc, char *argv[]) {
    // Create a socket
    int sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd == -1) {
        perror("socket");
        exit(EXIT_FAILURE);
    }

    // Connect to the server
    struct sockaddr_in servaddr;
    memset(&servaddr, 0, sizeof(servaddr));
    servaddr.sin_family = AF_INET;
    servaddr.sin_port = htons(PORT);
    servaddr.sin_addr.s_addr = INADDR_ANY;
    if (connect(sockfd, (struct sockaddr *)&servaddr, sizeof(servaddr)) == -1) {
        perror("connect");
        exit(EXIT_FAILURE);
    }

    // Send a message to the server
    char *msg = "Hello from the mind-bending client!";
    if (send(sockfd, msg, strlen(msg), 0) == -1) {
        perror("send");
        exit(EXIT_FAILURE);
    }

    // Receive a message from the server
    char buffer[BUFFER_SIZE];
    if (recv(sockfd, buffer, BUFFER_SIZE, 0) == -1) {
        perror("recv");
        exit(EXIT_FAILURE);
    }

    // Print the message from the server
    printf("Received from the server: %s\n", buffer);

    // Close the socket
    close(sockfd);

    return 0;
}