//Falcon-180B DATASET v1.0 Category: Database querying ; Style: imaginative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>

// Function prototypes
int callback(void *data, int argc, char **argv, char **azColName);
void createTable(sqlite3 *db);
void insertData(sqlite3 *db);
void queryData(sqlite3 *db);

int main() {
    sqlite3 *db;
    char *zErrMsg = 0;
    int rc;

    rc = sqlite3_open("database.db", &db);

    if (rc) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        sqlite3_close(db);
        exit(1);
    }

    createTable(db);
    insertData(db);
    queryData(db);

    sqlite3_close(db);
    return 0;
}

int callback(void *data, int argc, char **argv, char **azColName) {
    for (int i = 0; i < argc; i++) {
        printf("%s = %s\n", azColName[i], argv[i]? argv[i] : "NULL");
    }
    printf("\n");
    return 0;
}

void createTable(sqlite3 *db) {
    const char *sql = "CREATE TABLE IF NOT EXISTS users("
                      "id INTEGER PRIMARY KEY,"
                      "name TEXT,"
                      "age INTEGER);";

    char *errMsg = 0;
    int rc = sqlite3_exec(db, sql, NULL, NULL, &errMsg);

    if (rc!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", errMsg);
        sqlite3_free(errMsg);
    }
}

void insertData(sqlite3 *db) {
    const char *sql = "INSERT INTO users(name, age) VALUES('John', 30);";
    char *errMsg = 0;
    int rc = sqlite3_exec(db, sql, NULL, NULL, &errMsg);

    if (rc!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", errMsg);
        sqlite3_free(errMsg);
    }
}

void queryData(sqlite3 *db) {
    const char *sql = "SELECT * FROM users;";
    char *errMsg = 0;
    int rc = sqlite3_exec(db, sql, callback, NULL, &errMsg);

    if (rc!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", errMsg);
        sqlite3_free(errMsg);
    }
}