//GPT-4o-mini DATASET v1.0 Category: Disk space analyzer ; Style: detailed
#include <stdio.h>
#include <stdlib.h>
#include <sys/statvfs.h>
#include <string.h>

// Function to convert bytes into a human-readable format
void format_size(unsigned long long size, char *buffer, size_t buffer_size) {
    const char *units[] = { "B", "KB", "MB", "GB", "TB" };
    size_t unit_index = 0;
    double size_in_units = (double)size;

    while (size_in_units >= 1024 && unit_index < (sizeof(units) / sizeof(units[0])) - 1) {
        size_in_units /= 1024;
        unit_index++;
    }

    snprintf(buffer, buffer_size, "%.2f %s", size_in_units, units[unit_index]);
}

// Function to display disk space details
void display_disk_space(const char *path) {
    struct statvfs stat;

    if (statvfs(path, &stat) != 0) {
        perror("statvfs failed");
        return;
    }

    unsigned long long total_space = stat.f_blocks * stat.f_frsize;
    unsigned long long free_space = stat.f_bfree * stat.f_frsize;
    unsigned long long used_space = total_space - free_space;

    char total_buffer[50], free_buffer[50], used_buffer[50];
    
    format_size(total_space, total_buffer, sizeof(total_buffer));
    format_size(free_space, free_buffer, sizeof(free_buffer));
    format_size(used_space, used_buffer, sizeof(used_buffer));

    printf("Disk space for %s:\n", path);
    printf("Total Space: %s\n", total_buffer);
    printf("Used Space: %s\n", used_buffer);
    printf("Free Space: %s\n", free_buffer);
}

int main(int argc, char *argv[]) {
    if (argc < 2) {
        fprintf(stderr, "Usage: %s <mount_point>\n", argv[0]);
        return EXIT_FAILURE;
    }

    display_disk_space(argv[1]);

    // Additional functionality: list subdirectories and their sizes
    printf("\nSubdirectory Sizes:\n");
    char command[256];
    snprintf(command, sizeof(command), "du -h --max-depth=1 %s", argv[1]);
    system(command);

    return EXIT_SUCCESS;
}