//Falcon2-11B DATASET v1.0 Category: Geometric algorithms ; Style: optimized
#include <stdio.h>
#include <math.h>

// Calculate the distance between two points
float distance(float x1, float y1, float x2, float y2) {
    float dx = x2 - x1;
    float dy = y2 - y1;
    return sqrt(dx * dx + dy * dy);
}

// Calculate the angle between two vectors
float angle(float x1, float y1, float x2, float y2) {
    float dot = x1 * x2 + y1 * y2;
    float mag1 = sqrt(x1 * x1 + y1 * y1);
    float mag2 = sqrt(x2 * x2 + y2 * y2);
    return acos(dot / (mag1 * mag2));
}

// Calculate the cross product of two vectors
float cross(float x1, float y1, float x2, float y2) {
    return x1 * y2 - y1 * x2;
}

// Calculate the dot product of two vectors
float dot(float x1, float y1, float x2, float y2) {
    return x1 * x2 + y1 * y2;
}

// Calculate the midpoint between two points
float midpoint(float x1, float y1, float x2, float y2) {
    return (x1 + x2) / 2.0, (y1 + y2) / 2.0;
}

// Calculate the slope between two points
float slope(float x1, float y1, float x2, float y2) {
    float dy = y2 - y1;
    float dx = x2 - x1;
    return dy / dx;
}

// Calculate the intersection point of two lines
float intersection(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
    float m1 = slope(x1, y1, x2, y2);
    float m2 = slope(x3, y3, x4, y4);
    float b1 = y1 - x1 * m1;
    float b2 = y3 - x3 * m2;
    float x = (b2 - b1) / (m1 - m2);
    float y = x1 * m2 - x * m1 + b2;
    return x, y;
}

int main() {
    printf("Distance between (1, 2) and (4, 6) = %f\n", distance(1, 2, 4, 6));
    printf("Angle between (1, 0) and (2, 2) = %f\n", angle(1, 0, 2, 2));
    printf("Cross product of (2, 0) and (3, 4) = %f\n", cross(2, 0, 3, 4));
    printf("Dot product of (2, 3) and (3, 4) = %f\n", dot(2, 3, 3, 4));
    printf("Midpoint between (1, 2) and (3, 4) = (%f, %f)\n", midpoint(1, 2, 3, 4));
    printf("Slope between (1, 2) and (3, 4) = %f\n", slope(1, 2, 3, 4));
    printf("Intersection of lines y = x + 1 and y = 2x - 2 = (%f, %f)\n", intersection(1, 1, 3, 4, 3, -2, 5, -1));

    return 0;
}