//Falcon-180B DATASET v1.0 Category: Graph representation ; Style: future-proof
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NODES 1000
#define MAX_EDGES 2000
#define INF 9999999

typedef struct {
    int id;
    char name[50];
} Node;

typedef struct {
    int start, end;
    int weight;
} Edge;

Node nodes[MAX_NODES];
Edge edges[MAX_EDGES];
int num_nodes, num_edges;

void add_node(char name[50]) {
    if (num_nodes >= MAX_NODES) {
        printf("Error: Maximum number of nodes reached.\n");
        return;
    }
    strcpy(nodes[num_nodes].name, name);
    nodes[num_nodes].id = num_nodes;
    num_nodes++;
}

void add_edge(int start, int end, int weight) {
    if (num_edges >= MAX_EDGES) {
        printf("Error: Maximum number of edges reached.\n");
        return;
    }
    edges[num_edges].start = start;
    edges[num_edges].end = end;
    edges[num_edges].weight = weight;
    num_edges++;
}

void print_nodes() {
    printf("Nodes:\n");
    for (int i = 0; i < num_nodes; i++) {
        printf("%d - %s\n", i, nodes[i].name);
    }
}

void print_edges() {
    printf("\nEdges:\n");
    for (int i = 0; i < num_edges; i++) {
        printf("%d - %d (Weight: %d)\n", edges[i].start, edges[i].end, edges[i].weight);
    }
}

int main() {
    add_node("Node 1");
    add_node("Node 2");
    add_node("Node 3");
    add_node("Node 4");
    add_edge(0, 1, 5);
    add_edge(0, 2, 10);
    add_edge(1, 3, 2);
    add_edge(2, 1, 5);
    add_edge(2, 3, 1);
    add_edge(2, 4, 1);
    print_nodes();
    print_edges();
    return 0;
}