//Falcon-180B DATASET v1.0 Category: Password Strength Checker ; Style: visionary
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define PASSWORD_MIN_LENGTH 8
#define PASSWORD_MAX_LENGTH 32
#define PASSWORD_WEAK 0
#define PASSWORD_MEDIUM 1
#define PASSWORD_STRONG 2
#define PASSWORD_VERY_STRONG 3

int check_password_strength(char *password) {
    int length = strlen(password);
    if (length < PASSWORD_MIN_LENGTH || length > PASSWORD_MAX_LENGTH) {
        return PASSWORD_WEAK;
    }
    int has_uppercase = 0;
    int has_lowercase = 0;
    int has_number = 0;
    int has_special_char = 0;
    for (int i = 0; i < length; i++) {
        char c = tolower(password[i]);
        if (isalpha(c)) {
            if (isupper(c)) {
                has_uppercase = 1;
            } else {
                has_lowercase = 1;
            }
        } else if (isdigit(c)) {
            has_number = 1;
        } else if (!isalnum(c)) {
            has_special_char = 1;
        }
    }
    if (has_uppercase && has_lowercase && has_number && has_special_char) {
        return PASSWORD_VERY_STRONG;
    } else if (has_uppercase && has_lowercase && has_number) {
        return PASSWORD_STRONG;
    } else if (has_uppercase && has_lowercase || has_uppercase && has_number || has_lowercase && has_number) {
        return PASSWORD_MEDIUM;
    } else {
        return PASSWORD_WEAK;
    }
}

int main() {
    char password[PASSWORD_MAX_LENGTH+1];
    printf("Enter a password to check its strength: ");
    fgets(password, sizeof(password), stdin);
    password[strcspn(password, "\n")] = '\0';
    int strength = check_password_strength(password);
    switch(strength) {
        case PASSWORD_WEAK:
            printf("Weak\n");
            break;
        case PASSWORD_MEDIUM:
            printf("Medium\n");
            break;
        case PASSWORD_STRONG:
            printf("Strong\n");
            break;
        case PASSWORD_VERY_STRONG:
            printf("Very Strong\n");
            break;
    }
    return 0;
}