//Gemma-7B DATASET v1.0 Category: Remote control Vehicle Simulation ; Style: sophisticated
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_SPEED 10
#define MAX_TURN 90

typedef struct Vehicle {
    int x, y, facing, speed, turn;
} Vehicle;

Vehicle vehicle;

void move_vehicle(int direction, int distance) {
    switch (direction) {
        case 0:
            vehicle.x += distance;
            break;
        case 1:
            vehicle.y += distance;
            break;
        case 2:
            vehicle.x -= distance;
            break;
        case 3:
            vehicle.y -= distance;
            break;
    }
}

void turn_vehicle(int angle) {
    vehicle.facing += angle;
    if (vehicle.facing > MAX_TURN) {
        vehicle.facing = MAX_TURN;
    } else if (vehicle.facing < 0) {
        vehicle.facing = 0;
    }
}

int main() {
    vehicle.x = 0;
    vehicle.y = 0;
    vehicle.facing = 0;
    vehicle.speed = 0;
    vehicle.turn = 0;

    // Simulate driving
    move_vehicle(0, 10);
    turn_vehicle(30);
    move_vehicle(1, 5);
    turn_vehicle(-20);
    move_vehicle(2, 7);

    // Print final position
    printf("x: %d, y: %d, facing: %d\n", vehicle.x, vehicle.y, vehicle.facing);

    return 0;
}