//Falcon-180B DATASET v1.0 Category: Database simulation ; Style: interoperable
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

// Define the maximum number of records that can be stored in the database
#define MAX_RECORDS 100

// Define the structure of a record
typedef struct record {
    int id;
    char name[50];
    float salary;
} Record;

// Define the structure of the database
typedef struct database {
    Record records[MAX_RECORDS];
    int num_records;
} Database;

// Function to initialize the database
void init_database(Database *db) {
    db->num_records = 0;
}

// Function to add a record to the database
bool add_record(Database *db, Record record) {
    if (db->num_records >= MAX_RECORDS) {
        return false;
    }

    db->records[db->num_records] = record;
    db->num_records++;

    return true;
}

// Function to search for a record in the database
bool search_record(Database *db, int id) {
    for (int i = 0; i < db->num_records; i++) {
        if (db->records[i].id == id) {
            return true;
        }
    }

    return false;
}

// Function to print all records in the database
void print_records(Database *db) {
    printf("ID\tName\tSalary\n");
    for (int i = 0; i < db->num_records; i++) {
        printf("%d\t%s\t%.2f\n", db->records[i].id, db->records[i].name, db->records[i].salary);
    }
}

int main() {
    Database db;
    init_database(&db);

    Record record1 = {1, "John Doe", 50000};
    Record record2 = {2, "Jane Doe", 60000};
    Record record3 = {3, "Bob Smith", 70000};

    add_record(&db, record1);
    add_record(&db, record2);
    add_record(&db, record3);

    print_records(&db);

    if (search_record(&db, 2)) {
        printf("Record found with ID %d\n", 2);
    } else {
        printf("Record not found\n");
    }

    return 0;
}