//MISTRAL-7B DATASET v1.0 Category: Queue Implementation ; Style: happy
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define MAX_SIZE 10

typedef struct {
    int front;
    int rear;
    int arr[MAX_SIZE];
} JoyQueue;

void initQueue(JoyQueue *q) {
    q->front = -1;
    q->rear = -1;
}

int isFull(JoyQueue *q) {
    return (q->rear + 1) % MAX_SIZE == q->front;
}

int isEmpty(JoyQueue *q) {
    return q->front == -1 && q->rear == -1;
}

void enqueue(JoyQueue *q, int data) {
    if (isFull(q)) {
        printf("Error: Queue is full. Data %d cannot be added.\n", data);
        return;
    }

    if (isEmpty(q)) {
        q->front = 0;
        q->rear = 0;
    } else {
        q->rear = (q->rear + 1) % MAX_SIZE;
    }

    q->arr[q->rear] = data;
    printf("Success: Data %d added to JoyQueue with a smile 😊\n", data);
}

int dequeue(JoyQueue *q) {
    if (isEmpty(q)) {
        printf("Error: Queue is empty. No data to dequeue.\n");
        return -1;
    }

    int data = q->arr[q->front];

    if (q->front == q->rear) {
        q->front = -1;
        q->rear = -1;
    } else {
        q->front = (q->front + 1) % MAX_SIZE;
    }

    printf("Success: Data %d dequeued from JoyQueue with joy 🤗\n", data);
    return data;
}

void printQueue(JoyQueue *q) {
    if (isEmpty(q)) {
        printf("Error: Queue is empty.\n");
        return;
    }

    printf("JoyQueue: ");

    for (int i = q->front; i != q->rear; i = (i + 1) % MAX_SIZE) {
        printf("%d ", q->arr[i]);
    }

    printf("%d\n", q->arr[q->rear]);
}

int main() {
    JoyQueue joyQueue;
    initQueue(&joyQueue);

    enqueue(&joyQueue, 5);
    enqueue(&joyQueue, 10);
    enqueue(&joyQueue, 15);

    printQueue(&joyQueue);

    dequeue(&joyQueue);
    dequeue(&joyQueue);

    printQueue(&joyQueue);

    enqueue(&joyQueue, 20);
    printQueue(&joyQueue);

    return 0;
}