//Falcon-180B DATASET v1.0 Category: Digital Auction System ; Style: future-proof
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#define MAX_ITEMS 100
#define MAX_BIDS 100
#define MAX_BIDDERS 100
#define MAX_ITEM_NAME_LENGTH 100
#define MAX_BIDDER_NAME_LENGTH 100

typedef struct {
    char name[MAX_ITEM_NAME_LENGTH];
    int price;
    time_t timestamp;
    int bidder_index;
} item;

typedef struct {
    char name[MAX_BIDDER_NAME_LENGTH];
    int bid_amount;
} bidder;

item items[MAX_ITEMS];
bidder bidders[MAX_BIDDERS];
int num_items = 0;
int num_bidders = 0;

void add_item(char* name, int price) {
    strcpy(items[num_items].name, name);
    items[num_items].price = price;
    items[num_items].timestamp = time(NULL);
    items[num_items].bidder_index = -1;
    num_items++;
}

void add_bidder(char* name, int bid_amount) {
    strcpy(bidders[num_bidders].name, name);
    bidders[num_bidders].bid_amount = bid_amount;
    num_bidders++;
}

void start_auction(int item_index) {
    printf("Auction started for item %s\n", items[item_index].name);
}

void place_bid(int item_index, int bid_amount) {
    if (items[item_index].bidder_index == -1) {
        items[item_index].bidder_index = num_bidders - 1;
        items[item_index].price = bid_amount;
    } else if (items[item_index].bidder_index!= num_bidders - 1) {
        printf("Current highest bid is $%d by %s\n", items[item_index].price, bidders[items[item_index].bidder_index].name);
        printf("Do you want to place a higher bid? (y/n) ");
        char choice;
        scanf(" %c", &choice);
        if (choice == 'y') {
            items[item_index].bidder_index = num_bidders - 1;
            items[item_index].price = bid_amount;
        }
    } else {
        printf("You are already the highest bidder for this item\n");
    }
}

void end_auction(int item_index) {
    if (items[item_index].bidder_index!= -1) {
        printf("Auction ended for item %s\n", items[item_index].name);
        printf("Highest bid of $%d by %s\n", items[item_index].price, bidders[items[item_index].bidder_index].name);
    } else {
        printf("No bids were placed for item %s\n", items[item_index].name);
    }
}

int main() {
    add_item("Laptop", 1000);
    add_item("Phone", 500);
    add_item("Tablet", 800);

    add_bidder("Alice", 2000);
    add_bidder("Bob", 1500);
    add_bidder("Charlie", 1000);

    start_auction(0);

    place_bid(0, 1200);
    place_bid(1, 700);

    end_auction(0);
    end_auction(1);

    return 0;
}