//Gemma-7B DATASET v1.0 Category: Building a SMTP Client ; Style: Dennis Ritchie
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include <sys/socket.h>

#define MAX_BUFFER_SIZE 1024

int main() {
  int sockfd, newsockfd, port, n;
  char buffer[MAX_BUFFER_SIZE];

  // Create a socket
  sockfd = socket(AF_INET, SOCK_STREAM, htons(25));
  if (sockfd < 0) {
    perror("Error creating socket");
    exit(1);
  }

  // Bind the socket to a port
  struct sockaddr_in my_addr;
  my_addr.sin_family = AF_INET;
  my_addr.sin_port = htons(1234);
  if (bind(sockfd, (struct sockaddr *)&my_addr, sizeof(my_addr)) < 0) {
    perror("Error binding socket");
    exit(1);
  }

  // Listen for connections
  newsockfd = listen(sockfd, 5);
  if (newsockfd < 0) {
    perror("Error listening for connections");
    exit(1);
  }

  // Accept a connection
  struct sockaddr_in client_addr;
  int client_len = sizeof(client_addr);
  newsockfd = accept(sockfd, (struct sockaddr *)&client_addr, &client_len);
  if (newsockfd < 0) {
    perror("Error accepting connection");
    exit(1);
  }

  // Send and receive messages
  n = read(newsockfd, buffer, MAX_BUFFER_SIZE);
  if (n < 0) {
    perror("Error reading message");
    exit(1);
  }
  printf("Received: %s\n", buffer);

  n = write(newsockfd, buffer, MAX_BUFFER_SIZE);
  if (n < 0) {
    perror("Error writing message");
    exit(1);
  }
  printf("Sent: %s\n", buffer);

  // Close the connection
  close(newsockfd);

  return 0;
}