//GEMINI-pro DATASET v1.0 Category: Dice Roller ; Style: configurable
#include <stdio.h>
#include <stdlib.h>

// Define the maximum number of sides a die can have
#define MAX_SIDES 100

// Define the number of dice to roll
#define NUM_DICE 5

// Define the minimum and maximum values that can be rolled
#define MIN_VALUE 1
#define MAX_VALUE 6

// Declare the array of dice values
int diceValues[NUM_DICE];

// Function to roll a die
int rollDie(int numSides) {
  // Check if the number of sides is valid
  if (numSides < 1 || numSides > MAX_SIDES) {
    printf("Error: Invalid number of sides (%d)\n", numSides);
    return -1;
  }

  // Roll the die and return the result
  return (rand() % numSides) + 1;
}

// Function to roll the dice and store the results
void rollDice() {
  // Roll each die and store the result in the array
  for (int i = 0; i < NUM_DICE; i++) {
    diceValues[i] = rollDie(MAX_SIDES);
  }
}

// Function to print the results of the dice roll
void printResults() {
  // Print the values of the dice
  printf("Dice values: ");
  for (int i = 0; i < NUM_DICE; i++) {
    printf("%d ", diceValues[i]);
  }
  printf("\n");

  // Calculate the sum of the dice values
  int sum = 0;
  for (int i = 0; i < NUM_DICE; i++) {
    sum += diceValues[i];
  }

  // Print the sum of the dice values
  printf("Sum of dice values: %d\n", sum);
}

// Main function
int main() {
  // Set the random seed
  srand(time(NULL));

  // Roll the dice
  rollDice();

  // Print the results of the dice roll
  printResults();

  return 0;
}