//GPT-4o-mini DATASET v1.0 Category: Secure Password Generator ; Style: synchronous
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define PASSWORD_LENGTH 12
#define NUM_PASSWORDS 5

const char *upper_case = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
const char *lower_case = "abcdefghijklmnopqrstuvwxyz";
const char *digits = "0123456789";
const char *special_chars = "!@#$%^&*()-_=+[]{};:,.<>?";

void generate_password(char *password);

int main() {
    srand(time(NULL)); // Seed for random number generation
    char passwords[NUM_PASSWORDS][PASSWORD_LENGTH + 1]; // +1 for null terminator

    printf("Secure Password Generator\n");
    printf("=========================\n");

    for (int i = 0; i < NUM_PASSWORDS; i++) {
        generate_password(passwords[i]);
        printf("Password %d: %s\n", i + 1, passwords[i]);
    }

    return 0;
}

void generate_password(char *password) {
    // Ensure the password contains at least one character of each type
    password[0] = upper_case[rand() % strlen(upper_case)];
    password[1] = lower_case[rand() % strlen(lower_case)];
    password[2] = digits[rand() % strlen(digits)];
    password[3] = special_chars[rand() % strlen(special_chars)];

    // Fill the rest of the password with a combination of all character sets
    const char *all_chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()-_=+[]{};:,.<>?";
    for (int i = 4; i < PASSWORD_LENGTH; i++) {
        password[i] = all_chars[rand() % strlen(all_chars)];
    }

    // Shuffle the password
    for (int i = 0; i < PASSWORD_LENGTH; i++) {
        int j = rand() % PASSWORD_LENGTH;
        char temp = password[i];
        password[i] = password[j];
        password[j] = temp;
    }

    // Add null terminator
    password[PASSWORD_LENGTH] = '\0';
}