//Falcon-180B DATASET v1.0 Category: Packet Capturer with pcap library ; Style: Alan Turing
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>
#include <string.h>

#define SNAP_LEN 1024
#define MAX_PACKETS 1000

struct packet_data {
    u_char *packet;
    int size;
    struct packet_data *next;
};

struct packet_data *packets = NULL;

void process_packet(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    struct packet_data *new_packet = (struct packet_data *) malloc(sizeof(struct packet_data));
    new_packet->packet = (u_char *) malloc(header->len);
    new_packet->size = header->len;
    memcpy(new_packet->packet, packet, header->len);
    new_packet->next = NULL;

    if (packets == NULL) {
        packets = new_packet;
    } else {
        struct packet_data *temp = packets;
        while (temp->next!= NULL) {
            temp = temp->next;
        }
        temp->next = new_packet;
    }
}

void print_packets() {
    struct packet_data *temp = packets;
    while (temp!= NULL) {
        printf("Packet %d:\n", temp->size);
        for (int i = 0; i < temp->size; i++) {
            printf("%02X ", temp->packet[i]);
        }
        printf("\n\n");
        temp = temp->next;
    }
}

int main(int argc, char *argv[]) {
    char *dev = "eth0";
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;
    handle = pcap_open_live(dev, SNAP_LEN, 1, 0, errbuf);

    if (handle == NULL) {
        printf("Error opening device: %s\n", errbuf);
        exit(1);
    }

    pcap_loop(handle, -1, process_packet, NULL);

    pcap_close(handle);
    print_packets();

    return 0;
}