//Falcon-180B DATASET v1.0 Category: Database querying ; Style: synchronous
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>

// Function prototypes
int callback(void *data, int argc, char **argv, char **azColName);
char *errMsg = 0;
static int counter = 0;

int main() {
    sqlite3 *db;
    int rc;
    char *zErrMsg = 0;

    // Open the database
    rc = sqlite3_open("test.db", &db);
    if (rc) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        sqlite3_close(db);
        return 1;
    }

    // Create a table
    char *sql = "CREATE TABLE IF NOT EXISTS users (id INTEGER PRIMARY KEY AUTOINCREMENT, name TEXT, age INTEGER);";
    char *errMsg = 0;
    rc = sqlite3_exec(db, sql, 0, 0, &errMsg);
    if (rc!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", errMsg);
        sqlite3_free(errMsg);
    }

    // Insert some data
    sql = "INSERT INTO users (name, age) VALUES ('John', 30);";
    rc = sqlite3_exec(db, sql, 0, 0, &errMsg);
    if (rc!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", errMsg);
        sqlite3_free(errMsg);
    }

    // Query the data
    sql = "SELECT * FROM users;";
    rc = sqlite3_exec(db, sql, callback, 0, &errMsg);
    if (rc!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", errMsg);
        sqlite3_free(errMsg);
    }

    // Close the database
    sqlite3_close(db);
    return 0;
}

// Callback function for querying the data
int callback(void *data, int argc, char **argv, char **azColName) {
    printf("ID: %s, Name: %s, Age: %s\n", argv[0], argv[1], argv[2]);
    counter++;
    if (counter == 10) {
        sqlite3_interrupt(data);
    }
}