//Falcon-180B DATASET v1.0 Category: Network Topology Mapper ; Style: authentic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NODES 100
#define MAX_EDGES 200

typedef struct {
    char name[20];
    int id;
} Node;

typedef struct {
    int src_id;
    int dest_id;
} Edge;

int num_nodes = 0;
Node nodes[MAX_NODES];
int num_edges = 0;
Edge edges[MAX_EDGES];

void add_node(char* name) {
    if (num_nodes >= MAX_NODES) {
        printf("Error: Maximum number of nodes reached.\n");
        return;
    }
    strcpy(nodes[num_nodes].name, name);
    nodes[num_nodes].id = num_nodes;
    num_nodes++;
}

void add_edge(int src_id, int dest_id) {
    if (num_edges >= MAX_EDGES) {
        printf("Error: Maximum number of edges reached.\n");
        return;
    }
    edges[num_edges].src_id = src_id;
    edges[num_edges].dest_id = dest_id;
    num_edges++;
}

void print_nodes() {
    printf("Nodes:\n");
    for (int i = 0; i < num_nodes; i++) {
        printf("%d. %s\n", i, nodes[i].name);
    }
}

void print_edges() {
    printf("Edges:\n");
    for (int i = 0; i < num_edges; i++) {
        printf("%d -> %d\n", edges[i].src_id, edges[i].dest_id);
    }
}

int main() {
    add_node("Node 1");
    add_node("Node 2");
    add_node("Node 3");
    add_edge(0, 1);
    add_edge(1, 2);
    print_nodes();
    print_edges();
    return 0;
}