//GEMINI-pro DATASET v1.0 Category: Geometric algorithms ; Style: relaxed
#include <stdio.h>
#include <stdlib.h>

struct Point {
  double x, y;
};

struct Segment {
  struct Point a, b;
};

// Compute the area of the triangle defined by the three points
double triangle_area(struct Point *a, struct Point *b, struct Point *c) {
  double dx = b->x - a->x;
  double dy = b->y - a->y;
  double ex = c->x - a->x;
  double ey = c->y - a->y;
  return 0.5 * (dx * ey - dy * ex);
}

// Check if the point is inside the triangle defined by the three points
int point_in_triangle(struct Point *p, struct Point *a, struct Point *b, struct Point *c) {
  double A = triangle_area(a, b, c);
  double A1 = triangle_area(p, b, c);
  double A2 = triangle_area(a, p, c);
  double A3 = triangle_area(a, b, p);
  return (A == A1 + A2 + A3);
}

// Compute the distance between two points
double distance(struct Point *a, struct Point *b) {
  double dx = b->x - a->x;
  double dy = b->y - a->y;
  return sqrt(dx * dx + dy * dy);
}

// Check if the two segments intersect
int segments_intersect(struct Segment *s1, struct Segment *s2) {
  double d1 = distance(&s1->a, &s1->b);
  double d2 = distance(&s2->a, &s2->b);
  double d3 = distance(&s1->a, &s2->a);
  double d4 = distance(&s1->a, &s2->b);
  double d5 = distance(&s1->b, &s2->a);
  double d6 = distance(&s1->b, &s2->b);

  return (d3 + d4 <= d1 + d2) && (d5 + d6 <= d1 + d2);
}

// Find the intersection point of the two segments
struct Point *intersection(struct Segment *s1, struct Segment *s2) {
  double x1 = s1->a.x, x2 = s1->b.x, x3 = s2->a.x, x4 = s2->b.x;
  double y1 = s1->a.y, y2 = s1->b.y, y3 = s2->a.y, y4 = s2->b.y;

  double d = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
  if (d == 0) return NULL;  // Segments are parallel

  double t = ((x1 - x3) * (y3 - y4) - (y1 - y3) * (x3 - x4)) / d;
  double u = ((x2 - x1) * (y1 - y3) - (y2 - y1) * (x1 - x3)) / d;

  if (t >= 0 && t <= 1 && u >= 0 && u <= 1) {
    struct Point *p = malloc(sizeof(struct Point));
    p->x = x1 + t * (x2 - x1);
    p->y = y1 + t * (y2 - y1);
    return p;
  }

  return NULL;
}

// Main function
int main() {
  // Define the points
  struct Point a = {0, 0};
  struct Point b = {1, 0};
  struct Point c = {0, 1};
  struct Point d = {1, 1};
  struct Point e = {0.5, 0.5};

  // Define the segments
  struct Segment s1 = {a, b};
  struct Segment s2 = {c, d};

  // Check if the point is inside the triangle
  int inside_triangle = point_in_triangle(&e, &a, &b, &c);
  printf("Is point (0.5, 0.5) inside the triangle? %s\n", inside_triangle ? "Yes" : "No");

  // Check if the two segments intersect
  int intersect = segments_intersect(&s1, &s2);
  printf("Do segments [(0, 0), (1, 0)] and [(0, 1), (1, 1)] intersect? %s\n", intersect ? "Yes" : "No");

  // Find the intersection point of the two segments
  struct Point *p = intersection(&s1, &s2);
  if (p) {
    printf("Intersection point: (%.2f, %.2f)\n", p->x, p->y);
  } else {
    printf("Segments do not intersect\n");
  }

  return 0;
}