//GEMINI-pro DATASET v1.0 Category: Packet Capturer with pcap library ; Style: calm
#include <pcap.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/udp.h>
#include <arpa/inet.h>

#define MAX_BYTES_TO_CAPTURE 2048

void process_packet(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    struct ip *ip_header;
    struct tcphdr *tcp_header;
    struct udphdr *udp_header;

    int ip_header_len;
    int tcp_header_len;
    int udp_header_len;

    ip_header = (struct ip *)(packet + 14);
    ip_header_len = ip_header->ip_hl * 4;
    printf("IP Version: %d\n", ip_header->ip_v);
    printf("IP Header Length: %d bytes\n", ip_header_len);
    printf("IP Source Address: %s\n", inet_ntoa(ip_header->ip_src));
    printf("IP Destination Address: %s\n", inet_ntoa(ip_header->ip_dst));

    switch (ip_header->ip_p) {
        case IPPROTO_TCP:
            tcp_header = (struct tcphdr *)(packet + ip_header_len + 14);
            tcp_header_len = tcp_header->th_off * 4;
            printf("TCP Source Port: %d\n", ntohs(tcp_header->source));
            printf("TCP Destination Port: %d\n", ntohs(tcp_header->dest));
            break;
        case IPPROTO_UDP:
            udp_header = (struct udphdr *)(packet + ip_header_len + 14);
            udp_header_len = 8;
            printf("UDP Source Port: %d\n", ntohs(udp_header->source));
            printf("UDP Destination Port: %d\n", ntohs(udp_header->dest));
            break;
        default:
            printf("Unknown protocol: %d\n", ip_header->ip_p);
            break;
    }

    printf("\n");
}

int main() {
    char *device;
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;
    struct bpf_program fp;
    char filter_exp[] = "tcp and port 80";
    bpf_u_int32 net;
    bpf_u_int32 mask;
    int num_packets = 10;

    device = pcap_lookupdev(errbuf);
    if (device == NULL) {
        fprintf(stderr, "pcap_lookupdev() error: %s\n", errbuf);
        return 1;
    }

    if (pcap_lookupnet(device, &net, &mask, errbuf) == -1) {
        fprintf(stderr, "pcap_lookupnet() error: %s\n", errbuf);
        return 1;
    }

    handle = pcap_open_live(device, MAX_BYTES_TO_CAPTURE, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "pcap_open_live() error: %s\n", errbuf);
        return 1;
    }

    if (pcap_compile(handle, &fp, filter_exp, 0, net) == -1) {
        fprintf(stderr, "pcap_compile() error: %s\n", pcap_geterr(handle));
        return 1;
    }

    if (pcap_setfilter(handle, &fp) == -1) {
        fprintf(stderr, "pcap_setfilter() error: %s\n", pcap_geterr(handle));
        return 1;
    }

    pcap_loop(handle, num_packets, process_packet, NULL);

    pcap_close(handle);

    return 0;
}