//Gemma-7B DATASET v1.0 Category: Product Inventory System ; Style: cheerful
#include <stdio.h>
#include <stdlib.h>

#define MAX_ITEMS 10

typedef struct Item {
    char name[20];
    int quantity;
    float price;
} Item;

Item items[MAX_ITEMS];

void initializeItems() {
    for (int i = 0; i < MAX_ITEMS; i++) {
        items[i].name[0] = '\0';
        items[i].quantity = 0;
        items[i].price = 0.0f;
    }
}

void addItem(char *name, int quantity, float price) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] == '\0') {
            strcpy(items[i].name, name);
            items[i].quantity = quantity;
            items[i].price = price;
            return;
        }
    }

    printf("Error: Inventory full!");
}

int getItemQuantity(char *name) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (strcmp(items[i].name, name) == 0) {
            return items[i].quantity;
        }
    }

    return -1;
}

float getItemPrice(char *name) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (strcmp(items[i].name, name) == 0) {
            return items[i].price;
        }
    }

    return -1.0f;
}

int main() {
    initializeItems();

    addItem("Apple", 10, 1.2f);
    addItem("Banana", 5, 0.8f);
    addItem("Orange", 7, 1.5f);

    printf("Item quantity for Apple: %d\n", getItemQuantity("Apple"));
    printf("Item price for Orange: %.2f\n", getItemPrice("Orange"));

    return 0;
}