//GEMINI-pro DATASET v1.0 Category: Electronic Voting System ; Style: portable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of candidates and voters
#define MAX_CANDIDATES 10
#define MAX_VOTERS 100

// Define the data structures for the candidates and voters
typedef struct {
    char name[50];
    int votes;
} Candidate;

typedef struct {
    char name[50];
    int candidate_id;
} Voter;

// Declare the arrays to store the candidates and voters
Candidate candidates[MAX_CANDIDATES];
Voter voters[MAX_VOTERS];

// Declare the function to add a candidate
void add_candidate(char *name) {
    // Find the first empty slot in the candidates array
    int i;
    for (i = 0; i < MAX_CANDIDATES; i++) {
        if (candidates[i].name[0] == '\0') {
            break;
        }
    }

    // If there are no empty slots, print an error message
    if (i == MAX_CANDIDATES) {
        printf("Error: The maximum number of candidates has been reached.\n");
        return;
    }

    // Copy the candidate's name into the array
    strcpy(candidates[i].name, name);

    // Initialize the candidate's vote count to 0
    candidates[i].votes = 0;
}

// Declare the function to add a voter
void add_voter(char *name, int candidate_id) {
    // Find the first empty slot in the voters array
    int i;
    for (i = 0; i < MAX_VOTERS; i++) {
        if (voters[i].name[0] == '\0') {
            break;
        }
    }

    // If there are no empty slots, print an error message
    if (i == MAX_VOTERS) {
        printf("Error: The maximum number of voters has been reached.\n");
        return;
    }

    // Copy the voter's name into the array
    strcpy(voters[i].name, name);

    // Store the voter's candidate ID
    voters[i].candidate_id = candidate_id;
}

// Declare the function to cast a vote
void cast_vote(int voter_id, int candidate_id) {
    // Find the voter in the voters array
    int i;
    for (i = 0; i < MAX_VOTERS; i++) {
        if (voters[i].name[0] != '\0' && voters[i].candidate_id == candidate_id) {
            break;
        }
    }

    // If the voter is not found, print an error message
    if (i == MAX_VOTERS) {
        printf("Error: The voter is not registered.\n");
        return;
    }

    // Increment the vote count for the candidate
    candidates[candidate_id].votes++;
}

// Declare the function to print the results
void print_results() {
    // Find the candidate with the most votes
    int i;
    int max_votes = 0;
    int winner_id = -1;
    for (i = 0; i < MAX_CANDIDATES; i++) {
        if (candidates[i].name[0] != '\0' && candidates[i].votes > max_votes) {
            max_votes = candidates[i].votes;
            winner_id = i;
        }
    }

    // Print the name of the winner
    if (winner_id != -1) {
        printf("The winner is: %s\n", candidates[winner_id].name);
    } else {
        printf("There is no winner.\n");
    }
}

// Declare the main function
int main() {
    // Add some candidates
    add_candidate("Alice");
    add_candidate("Bob");
    add_candidate("Carol");

    // Add some voters
    add_voter("John", 0);
    add_voter("Mary", 1);
    add_voter("Tom", 2);

    // Cast some votes
    cast_vote(0, 0);
    cast_vote(1, 1);
    cast_vote(2, 2);

    // Print the results
    print_results();

    return 0;
}