//GEMINI-pro DATASET v1.0 Category: Natural Language Date Converter ; Style: detailed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct date {
    int year;
    int month;
    int day;
} date_t;

int is_leap_year(int year) {
    if (year % 400 == 0) {
        return 1;
    } else if (year % 100 == 0) {
        return 0;
    } else if (year % 4 == 0) {
        return 1;
    } else {
        return 0;
    }
}

int days_in_month(int month, int year) {
    if (month == 2) {
        if (is_leap_year(year)) {
            return 29;
        } else {
            return 28;
        }
    } else if (month == 4 || month == 6 || month == 9 || month == 11) {
        return 30;
    } else {
        return 31;
    }
}

int days_in_year(int year) {
    if (is_leap_year(year)) {
        return 366;
    } else {
        return 365;
    }
}

int days_between(date_t date1, date_t date2) {
    int days = 0;
    if (date1.year < date2.year) {
        for (int i = date1.year + 1; i < date2.year; i++) {
            days += days_in_year(i);
        }
    }
    for (int i = date1.month + 1; i <= 12; i++) {
        days += days_in_month(i, date1.year);
    }
    for (int i = 1; i < date2.month; i++) {
        days += days_in_month(i, date2.year);
    }
    days += date2.day - date1.day;
    return days;
}

void print_date(date_t date) {
    printf("%d-%d-%d\n", date.year, date.month, date.day);
}

date_t add_days(date_t date, int days) {
    date.day += days;
    while (date.day > days_in_month(date.month, date.year)) {
        date.day -= days_in_month(date.month, date.year);
        date.month++;
        if (date.month > 12) {
            date.month = 1;
            date.year++;
        }
    }
    return date;
}

date_t subtract_days(date_t date, int days) {
    date.day -= days;
    while (date.day < 1) {
        date.month--;
        if (date.month < 1) {
            date.month = 12;
            date.year--;
        }
        date.day += days_in_month(date.month, date.year);
    }
    return date;
}

int main(void) {
    date_t date1 = {2020, 1, 1};
    date_t date2 = {2020, 12, 31};
    printf("Days between %d-%d-%d and %d-%d-%d: %d\n", date1.year, date1.month, date1.day, date2.year, date2.month, date2.day, days_between(date1, date2));
    date_t date3 = add_days(date1, 100);
    printf("100 days after %d-%d-%d: ", date1.year, date1.month, date1.day);
    print_date(date3);
    date_t date4 = subtract_days(date2, 100);
    printf("100 days before %d-%d-%d: ", date2.year, date2.month, date2.day);
    print_date(date4);
    return 0;
}