//Falcon-180B DATASET v1.0 Category: File system simulation ; Style: inquisitive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_FILES 100
#define MAX_FILE_NAME_LEN 50
#define MAX_PATH_LEN 100

typedef struct {
    char name[MAX_FILE_NAME_LEN];
    int size;
    char content[MAX_FILE_NAME_LEN];
} File;

File files[MAX_FILES];
int numFiles = 0;

void createFile(char* name, int size) {
    for (int i = 0; i < numFiles; i++) {
        if (strcmp(name, files[i].name) == 0) {
            printf("File already exists.\n");
            return;
        }
    }

    strcpy(files[numFiles].name, name);
    files[numFiles].size = size;
    strcpy(files[numFiles].content, "");

    numFiles++;
}

void deleteFile(char* name) {
    for (int i = 0; i < numFiles; i++) {
        if (strcmp(name, files[i].name) == 0) {
            strcpy(files[i].name, "");
            strcpy(files[i].content, "");
            printf("File deleted.\n");
            return;
        }
    }

    printf("File not found.\n");
}

void renameFile(char* oldName, char* newName) {
    for (int i = 0; i < numFiles; i++) {
        if (strcmp(oldName, files[i].name) == 0) {
            strcpy(files[i].name, newName);
            printf("File renamed.\n");
            return;
        }
    }

    printf("File not found.\n");
}

void writeFile(char* name, char* content) {
    for (int i = 0; i < numFiles; i++) {
        if (strcmp(name, files[i].name) == 0) {
            strcpy(files[i].content, content);
            printf("File written.\n");
            return;
        }
    }

    printf("File not found.\n");
}

void readFile(char* name) {
    for (int i = 0; i < numFiles; i++) {
        if (strcmp(name, files[i].name) == 0) {
            printf("File content: %s\n", files[i].content);
            return;
        }
    }

    printf("File not found.\n");
}

int main() {
    createFile("test.txt", 10);
    writeFile("test.txt", "Hello, world!");
    readFile("test.txt");

    renameFile("test.txt", "new_file.txt");
    readFile("new_file.txt");

    deleteFile("new_file.txt");

    return 0;
}