//GEMINI-pro DATASET v1.0 Category: String manipulation ; Style: real-life
#include <stdio.h>
#include <string.h>

// Function to count the number of vowels in a string
int countVowels(char *str) {
    int count = 0;
    for (int i = 0; str[i]; i++) {
        if (str[i] == 'a' || str[i] == 'e' || str[i] == 'i' || str[i] == 'o' || str[i] == 'u') {
            count++;
        } else if (str[i] == 'A' || str[i] == 'E' || str[i] == 'I' || str[i] == 'O' || str[i] == 'U') {
            count++;
        }
    }
    return count;
}

// Function to reverse a string
void reverseString(char *str) {
    int len = strlen(str);
    for (int i = 0; i < len / 2; i++) {
        char temp = str[i];
        str[i] = str[len - i - 1];
        str[len - i - 1] = temp;
    }
}

// Function to check if a string is a palindrome
int isPalindrome(char *str) {
    int len = strlen(str);
    for (int i = 0; i < len / 2; i++) {
        if (str[i] != str[len - i - 1]) {
            return 0;
        }
    }
    return 1;
}

// Function to convert a string to uppercase
void toUpperCase(char *str) {
    int len = strlen(str);
    for (int i = 0; i < len; i++) {
        if (str[i] >= 'a' && str[i] <= 'z') {
            str[i] = str[i] - 32;
        }
    }
}

// Function to convert a string to lowercase
void toLowerCase(char *str) {
    int len = strlen(str);
    for (int i = 0; i < len; i++) {
        if (str[i] >= 'A' && str[i] <= 'Z') {
            str[i] = str[i] + 32;
        }
    }
}

// Function to find the first occurrence of a character in a string
int findChar(char *str, char ch) {
    int len = strlen(str);
    for (int i = 0; i < len; i++) {
        if (str[i] == ch) {
            return i;
        }
    }
    return -1;
}

// Function to find the last occurrence of a character in a string
int findLastChar(char *str, char ch) {
    int len = strlen(str);
    for (int i = len - 1; i >= 0; i--) {
        if (str[i] == ch) {
            return i;
        }
    }
    return -1;
}

// Function to replace all occurrences of a character in a string with another character
void replaceChar(char *str, char oldCh, char newCh) {
    int len = strlen(str);
    for (int i = 0; i < len; i++) {
        if (str[i] == oldCh) {
            str[i] = newCh;
        }
    }
}

// Function to remove all occurrences of a character from a string
void removeChar(char *str, char ch) {
    int len = strlen(str);
    int j = 0;
    for (int i = 0; i < len; i++) {
        if (str[i] != ch) {
            str[j++] = str[i];
        }
    }
    str[j] = '\0';
}

int main() {
    char str[] = "Hello World";

    // Count the number of vowels in the string
    printf("Number of vowels: %d\n", countVowels(str));

    // Reverse the string
    reverseString(str);
    printf("Reversed string: %s\n", str);

    // Check if the string is a palindrome
    if (isPalindrome(str)) {
        printf("The string is a palindrome.\n");
    } else {
        printf("The string is not a palindrome.\n");
    }

    // Convert the string to uppercase
    toUpperCase(str);
    printf("Uppercase string: %s\n", str);

    // Convert the string to lowercase
    toLowerCase(str);
    printf("Lowercase string: %s\n", str);

    // Find the first occurrence of a character in the string
    int index = findChar(str, 'o');
    printf("First occurrence of 'o': %d\n", index);

    // Find the last occurrence of a character in the string
    index = findLastChar(str, 'o');
    printf("Last occurrence of 'o': %d\n", index);

    // Replace all occurrences of a character in the string with another character
    replaceChar(str, 'o', 'a');
    printf("Replaced string: %s\n", str);

    // Remove all occurrences of a character from a string
    removeChar(str, 'a');
    printf("Removed string: %s\n", str);

    return 0;
}