//Falcon-180B DATASET v1.0 Category: Product Inventory System ; Style: expert-level
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PRODUCTS 1000
#define MAX_NAME_LENGTH 50
#define MAX_DESCRIPTION_LENGTH 100
#define MAX_PRICE_LENGTH 10
#define MAX_QUANTITY_LENGTH 10

typedef struct {
    char name[MAX_NAME_LENGTH];
    char description[MAX_DESCRIPTION_LENGTH];
    char price[MAX_PRICE_LENGTH];
    int quantity;
} Product;

int numProducts = 0;
Product products[MAX_PRODUCTS];

void addProduct() {
    numProducts++;
}

void removeProduct(int index) {
    numProducts--;
    for (int i = index; i < numProducts; i++) {
        strcpy(products[i].name, products[i+1].name);
        strcpy(products[i].description, products[i+1].description);
        strcpy(products[i].price, products[i+1].price);
        products[i].quantity = products[i+1].quantity;
    }
}

void displayProducts() {
    printf("Product Inventory:\n");
    printf("-----------------\n");
    printf("ID\tName\tDescription\tPrice\tQuantity\n");
    for (int i = 0; i < numProducts; i++) {
        printf("%d\t%s\t%s\t%s\t%d\n", i+1, products[i].name, products[i].description, products[i].price, products[i].quantity);
    }
    printf("\n");
}

void searchProduct(char *name) {
    int found = 0;
    printf("Search results for '%s':\n", name);
    for (int i = 0; i < numProducts; i++) {
        if (strcmp(products[i].name, name) == 0) {
            printf("%d. %s\t%s\t%s\t%d\n", i+1, products[i].name, products[i].description, products[i].price, products[i].quantity);
            found = 1;
        }
    }
    if (!found) {
        printf("No products found.\n");
    }
}

int main() {
    addProduct();
    addProduct();
    addProduct();

    displayProducts();

    searchProduct("Product 1");

    removeProduct(1);

    displayProducts();

    return 0;
}