//GPT-4o-mini DATASET v1.0 Category: Planet Gravity Simulation ; Style: medieval
#include <stdio.h>
#include <math.h>

#define G 6.67430e-11 // Gravitational constant
#define MAX_PLANETS 10

typedef struct {
    char name[20];
    double mass;  // Mass in kilograms
    double x, y;  // Position in meters
} Planet;

void calculate_gravity(Planet planets[], int count) {
    for (int i = 0; i < count; i++) {
        printf("\nGravity exerted on %s:\n", planets[i].name);
        for (int j = 0; j < count; j++) {
            if (i != j) {
                double dx = planets[j].x - planets[i].x;
                double dy = planets[j].y - planets[i].y;
                double distance_squared = dx * dx + dy * dy;
                double force = (G * planets[i].mass * planets[j].mass) / distance_squared;
                printf(" - By %s: %.2e N\n", planets[j].name, force);
            }
        }
    }
}

void display_planet_info(Planet planets[], int count) {
    printf("Regal Planets and Their Attributes:\n");
    printf("-----------------------------------------------------\n");
    for (int i = 0; i < count; i++) {
        printf("Name: %s, Mass: %.2e kg, Position: (%.2f, %.2f)\n",
               planets[i].name, planets[i].mass, planets[i].x, planets[i].y);
    }
    printf("-----------------------------------------------------\n");
}

int main() {
    Planet planets[MAX_PLANETS];
    int planet_count = 0;

    // Adding planets to our noble realm
    snprintf(planets[planet_count].name, sizeof(planets[planet_count].name), "Aetheria");
    planets[planet_count].mass = 5.972e24; // Earth's mass
    planets[planet_count].x = 0.0; // Position
    planets[planet_count].y = 0.0;
    planet_count++;

    snprintf(planets[planet_count].name, sizeof(planets[planet_count].name), "Terragor");
    planets[planet_count].mass = 1.0e24; // A fictional planet mass
    planets[planet_count].x = 1.0e11; // Position
    planets[planet_count].y = 0.0;
    planet_count++;

    snprintf(planets[planet_count].name, sizeof(planets[planet_count].name), "Mystarion");
    planets[planet_count].mass = 3.0e24; // Another fictional planet mass
    planets[planet_count].x = 0.0;
    planets[planet_count].y = 1.0e11;
    planet_count++;

    // Display planet information
    display_planet_info(planets, planet_count);

    // Calculate and display gravitational forces
    calculate_gravity(planets, planet_count);

    return 0;
}