//MISTRAL-7B DATASET v1.0 Category: Checksum Calculator ; Style: cheerful
#include <stdio.h>
#include <stdint.h>
#include <string.h>

#define CHECKSUM_SIZE 4

typedef uint32_t checksum_t;

// Calculate checksum using Adler-32 algorithm
checksum_t adler32(const uint8_t *buf, size_t len) {
    checksum_t s1 = 1, s2 = 0;

    while (len--) {
        s1 = (s1 + *buf++) % 65521;
        s2 = (s2 + s1) % 65521;
    }

    s1 = (s1 << 16) | (s1 & 0xFFFF);
    s2 = (s2 << 16) | (s2 & 0xFFFF);
    s1 += s2;
    s2 = s1;
    s1 += len;

    return s1 % 65521;
}

void printChecksum(const uint8_t *buf, size_t len) {
    checksum_t checksum = adler32(buf, len);
    printf("Checksum for the given input:\n");
    printf("Size: %zu\n", len);
    printf("Checksum: ");

    // Convert checksum to hexadecimal and print with spaces in between
    for (int i = 0; i < CHECKSUM_SIZE * 2; i += 2) {
        int hex = (checksum >> (i * 4)) & 0xF;
        printf("%02X ", hex);
    }

    printf("\n");
}

int main() {
    const uint8_t input[] = "This program calculates a cheerful checksum using the Adler-32 algorithm!";

    size_t inputLen = strlen((const char *)input);

    printf("Input data:\n");
    printf("%s\n", input);

    printChecksum(input, inputLen);

    return 0;
}