//GEMINI-pro DATASET v1.0 Category: Smart home automation ; Style: statistical
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <stdbool.h>

// Define the number of devices in the smart home
#define NUM_DEVICES 5

// Define the types of devices in the smart home
typedef enum {
    LIGHT,
    THERMOSTAT,
    FAN,
    DOOR,
    WINDOW
} device_type_t;

// Define the states of the devices in the smart home
typedef enum {
    ON,
    OFF,
    OPEN,
    CLOSED
} device_state_t;

// Define the structure of a device in the smart home
typedef struct {
    device_type_t type;
    device_state_t state;
    uint8_t id;
} device_t;

// Define the smart home as an array of devices
device_t smart_home[NUM_DEVICES];

// Initialize the smart home
void init_smart_home() {
    for (int i = 0; i < NUM_DEVICES; i++) {
        smart_home[i].type = rand() % NUM_DEVICES;
        smart_home[i].state = rand() % 2;
        smart_home[i].id = i;
    }
}

// Print the state of the smart home
void print_smart_home() {
    for (int i = 0; i < NUM_DEVICES; i++) {
        printf("Device %d: ", smart_home[i].id);
        switch (smart_home[i].type) {
            case LIGHT:
                printf("Light ");
                break;
            case THERMOSTAT:
                printf("Thermostat ");
                break;
            case FAN:
                printf("Fan ");
                break;
            case DOOR:
                printf("Door ");
                break;
            case WINDOW:
                printf("Window ");
                break;
        }
        switch (smart_home[i].state) {
            case ON:
                printf("ON\n");
                break;
            case OFF:
                printf("OFF\n");
                break;
            case OPEN:
                printf("OPEN\n");
                break;
            case CLOSED:
                printf("CLOSED\n");
                break;
        }
    }
}

// Main function
int main() {
    // Initialize the smart home
    init_smart_home();

    // Print the state of the smart home
    print_smart_home();

    return 0;
}