//Falcon-180B DATASET v1.0 Category: Fitness Tracker ; Style: optimized
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_USER 100
#define MAX_WORKOUT_TYPE 10
#define MAX_WORKOUT_NAME 50
#define MAX_DURATION 10
#define MAX_CALORIES 1000

typedef struct {
    char name[MAX_USER];
    int age;
    int gender;
} User;

typedef struct {
    char name[MAX_WORKOUT_NAME];
    int type;
    int duration;
    int calories;
} Workout;

User user[MAX_USER];
Workout workout[MAX_WORKOUT_TYPE][MAX_WORKOUT_NAME];

void addUser(User* u) {
    int i = 0;
    while (i < MAX_USER && user[i].name[0]!= '\0') {
        i++;
    }
    strcpy(user[i].name, u->name);
    user[i].age = u->age;
    user[i].gender = u->gender;
}

void addWorkout(Workout* w) {
    int i = 0;
    while (i < MAX_WORKOUT_TYPE && workout[i][0].name[0]!= '\0') {
        i++;
    }
    strcpy(workout[i][0].name, w->name);
    workout[i][0].type = w->type;
    workout[i][0].duration = w->duration;
    workout[i][0].calories = w->calories;
}

int main() {
    srand(time(NULL));

    User u = {"John", 25, 1};
    Workout w = {"Running", 1, 30, 200};

    addUser(&u);
    addWorkout(&w);

    return 0;
}