//LLAMA2-13B DATASET v1.0 Category: Sorting ; Style: careful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define ARRAY_SIZE 10

// Structure to represent a color
typedef struct {
    char name[20];
    int frequency;
} color_t;

// Function to sort an array of colors by frequency
void sort_colors(color_t colors[ARRAY_SIZE]) {
    int i, j, min_idx;
    color_t temp;

    // Loop until the array is sorted
    for (i = 0; i < ARRAY_SIZE - 1; i++) {
        // Find the smallest frequency
        min_idx = i;
        for (j = i + 1; j < ARRAY_SIZE; j++) {
            if (colors[j].frequency < colors[min_idx].frequency) {
                min_idx = j;
            }
        }

        // Swap the colors
        temp = colors[min_idx];
        colors[min_idx] = colors[i];
        colors[i] = temp;
    }
}

int main() {
    color_t colors[ARRAY_SIZE] = {
        {"Red", 30},
        {"Blue", 20},
        {"Green", 15},
        {"Yellow", 10},
        {"Orange", 5},
        {"Purple", 10},
        {"Black", 25},
        {"White", 35},
        {"Gray", 20},
        {"Brown", 15}
    };

    // Sort the colors by frequency
    sort_colors(colors);

    // Print the sorted colors
    for (int i = 0; i < ARRAY_SIZE; i++) {
        printf("%s (%d)\n", colors[i].name, colors[i].frequency);
    }

    return 0;
}